/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.items.trinkets;

import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.blocks.BlockTeddyBear;
import xzeroair.trinkets.blocks.tileentities.TileEntityTeddyBear;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.init.ModBlocks;
import xzeroair.trinkets.items.base.AccessoryBase;
import xzeroair.trinkets.traits.abilities.AbilityWellRested;
import xzeroair.trinkets.traits.abilities.interfaces.IAbilityInterface;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.trinkets.ConfigTeddyBear;

public class TrinketTeddyBear
extends AccessoryBase {
    public static final ConfigTeddyBear serverConfig = TrinketsConfig.SERVER.Items.TEDDY_BEAR;

    public TrinketTeddyBear(String name) {
        super(name);
        this.setUUID("33b34669-715d-4caa-a31e-9c643c52ba66");
    }

    @Override
    public String[] getAttributeConfig() {
        return TrinketTeddyBear.serverConfig.attributes;
    }

    @Override
    public void initAbilities(ItemStack stack, EntityLivingBase entity, List<IAbilityInterface> abilities) {
        if (TrinketTeddyBear.serverConfig.sleep_bonus) {
            abilities.add(new AbilityWellRested());
        }
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        return Capabilities.getTrinketProperties(stack, super.func_77653_i(stack), (prop, name) -> {
            String crafter = prop.getCrafter();
            if (!crafter.isEmpty() && !stack.func_82837_s()) {
                return crafter + "'s " + name;
            }
            return name;
        });
    }

    public int getTeddyVariant(ItemStack stack) {
        if (stack != null && !stack.func_190926_b()) {
            String name = stack.func_82833_r().toLowerCase();
            String crafterID = Capabilities.getTrinketProperties(stack, "", (prop, UUID2) -> {
                String ID = prop.getCrafterUUID();
                if (!ID.isEmpty()) {
                    return ID;
                }
                return UUID2;
            });
            boolean hasDisplayName = stack.func_82837_s();
            if (crafterID.equalsIgnoreCase("854adc0b-ae55-48d6-b7ba-e641a1eebf42") && !hasDisplayName || name.contains("nyan")) {
                return 10;
            }
            if (name.contains("ken")) {
                return 9;
            }
            if (name.contains("ryu")) {
                return 8;
            }
            if (crafterID.equalsIgnoreCase("b2b629a6-454e-4047-a143-4f357171d639") && !hasDisplayName || name.contains("twilight")) {
                return 7;
            }
            if (crafterID.equalsIgnoreCase("14bba455-affa-46d0-9cf0-806cc0f3d454") && !hasDisplayName || name.contains("artsy")) {
                return 6;
            }
            if (crafterID.equalsIgnoreCase("5a215d65-e57d-47c6-a322-9ede12a4a100") && !hasDisplayName || name.contains("potastic") || name.contains("potasticP") || name.contains("panda")) {
                return 5;
            }
            if (crafterID.equalsIgnoreCase("7d50a302-a01c-4e6a-8ea4-03f98662df28") && !hasDisplayName || name.contains("stingin") || name.contains("bee") || name.contains("bzzz")) {
                return 4;
            }
            if (crafterID.equalsIgnoreCase("cdfccefb-1a2e-4fb8-a3b5-041da27fde61") && !hasDisplayName || name.contains("shivaxi")) {
                return 3;
            }
            if (crafterID.equalsIgnoreCase("6b5d5e9b-1fe8-4c61-a043-1d84ce95765d") && !hasDisplayName || name.contains("rembo") || name.contains("cool") || name.contains("badass")) {
                return 1;
            }
            if (name.contains("scary") || name.contains("freddy") || name.contains("snuggles")) {
                return 2;
            }
            return 0;
        }
        return 0;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate;
        Block block;
        boolean flag;
        if (facing == EnumFacing.DOWN) {
            return EnumActionResult.FAIL;
        }
        if (world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
            facing = EnumFacing.UP;
            pos = pos.func_177977_b();
        }
        if (!(flag = (block = (iblockstate = world.func_180495_p(pos)).func_177230_c()).func_176200_f((IBlockAccess)world, pos))) {
            if (!world.func_180495_p(pos).func_185904_a().func_76220_a() && !world.isSideSolid(pos, facing, true)) {
                return EnumActionResult.FAIL;
            }
            pos = pos.func_177972_a(facing);
        }
        ItemStack itemstack = player.func_184586_b(hand);
        BlockTeddyBear TeddyBlock = ModBlocks.Placeables.getTeddy(this.getTeddyVariant(itemstack));
        if (player.func_175151_a(pos, facing, itemstack) && TeddyBlock.func_176196_c(world, pos)) {
            if (world.field_72995_K) {
                return EnumActionResult.SUCCESS;
            }
            IBlockState iblockstate1 = TeddyBlock.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
            if (this.placeBlockAt(itemstack, player, world, pos, facing, hitX, hitY, hitZ, iblockstate1)) {
                TileEntity tileentity;
                int i = 0;
                if (facing == EnumFacing.UP) {
                    i = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 16.0f / 360.0f) + 0.5)) & 0xF;
                }
                if ((tileentity = world.func_175625_s(pos)) instanceof TileEntityTeddyBear) {
                    TileEntityTeddyBear teddy = (TileEntityTeddyBear)tileentity;
                    teddy.setRotation(i);
                }
                iblockstate1 = world.func_180495_p(pos);
                SoundType soundtype = iblockstate1.func_177230_c().getSoundType(iblockstate1, world, pos, (Entity)player);
                world.func_184133_a((EntityPlayer)null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                itemstack.func_190918_g(1);
                if (player instanceof EntityPlayerMP) {
                    CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, itemstack);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!world.func_180501_a(pos, newState, 11)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        BlockTeddyBear myBlock = ModBlocks.Placeables.getTeddy(this.getTeddyVariant(stack));
        if (state.func_177230_c() == myBlock) {
            ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
            myBlock.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
            }
        }
        return true;
    }

    @Override
    public boolean ItemEnabled() {
        return TrinketTeddyBear.serverConfig.enabled;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelResourceLocation normal = new ModelResourceLocation(this.getRegistryName().toString(), "inventory");
        ModelResourceLocation rembo = new ModelResourceLocation(this.getRegistryName().toString() + "_rembos", "inventory");
        ModelResourceLocation scary = new ModelResourceLocation(this.getRegistryName().toString() + "_scary", "inventory");
        ModelResourceLocation shivaxi = new ModelResourceLocation(this.getRegistryName().toString() + "_shivaxi", "inventory");
        ModelResourceLocation bee = new ModelResourceLocation(this.getRegistryName().toString() + "_bee", "inventory");
        ModelResourceLocation panda = new ModelResourceLocation(this.getRegistryName().toString() + "_panda", "inventory");
        ModelResourceLocation artsy = new ModelResourceLocation(this.getRegistryName().toString() + "_artsy", "inventory");
        ModelResourceLocation twilight = new ModelResourceLocation(this.getRegistryName().toString() + "_twilight", "inventory");
        ModelResourceLocation ryu = new ModelResourceLocation(this.getRegistryName().toString() + "_ryu", "inventory");
        ModelResourceLocation ken = new ModelResourceLocation(this.getRegistryName().toString() + "_ken", "inventory");
        ModelResourceLocation nyan = new ModelResourceLocation(this.getRegistryName().toString() + "_nyan", "inventory");
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{normal, scary, rembo, shivaxi, bee, panda, artsy, twilight, ryu, ken, nyan});
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            int type = this.getTeddyVariant(stack);
            if (type == 10) {
                return nyan;
            }
            if (type == 9) {
                return ken;
            }
            if (type == 8) {
                return ryu;
            }
            if (type == 7) {
                return twilight;
            }
            if (type == 6) {
                return artsy;
            }
            if (type == 5) {
                return panda;
            }
            if (type == 4) {
                return bee;
            }
            if (type == 3) {
                return shivaxi;
            }
            if (type == 2) {
                return scary;
            }
            if (type == 1) {
                return rembo;
            }
            return normal;
        });
    }
}

